import pandas as pd   
import matplotlib.pyplot as plt  
import seaborn as sns  

   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv") 

  
# Distribution plot for credit history  
plt.figure(figsize=(10, 6))   
sns.countplot(x='credit_history', data=credit_customers, order=credit_customers['credit_history'].value_counts().index)   
plt.title("Credit History Distribution")   
plt.xlabel("Credit History")   
plt.ylabel("Frequency")   
plt.xticks(rotation=45)    
plt.savefig('ref_result/countplot_2.png') 
plt.show()  
